/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceKey;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.exception.annotation.ErrorCodeCategory;
import oracle.install.commons.util.exception.annotation.ErrorCodeDef;
import oracle.install.commons.util.message.Content;

public class ErrorInfo {
    private static final Logger logger = Logger.getLogger(ErrorInfo.class.getName());
    private ErrorCode errorCode;
    private String errorId;
    private String categoryId;
    private Severity severity;
    private String helpId;
    private String resourceBundle;
    private String message;
    private String hintId;
    private String hint;
    private String errorFQN;
    private String type;
    private String description;
    private String cause;
    private String action;
    private Object[] messageArgs;
    private Content extraDetails;
    private static final String FMT_ERROR_FQN = "{0}-{1}{2}";
    private static final String FMT_ERROR_MESSAGE = "[{0}] {1}";

    public static ErrorInfo getInstance(ErrorCode errorCode, Object ... messageArgs) {
        ErrorInfo errorInfo = null;
        if (errorCode != null) {
            errorInfo = new ErrorInfo(errorCode, messageArgs);
        }
        return errorInfo;
    }

    protected ErrorInfo(ErrorCode errorCode, Object ... messageArgs) {
        this.errorCode = errorCode;
        this.messageArgs = messageArgs;
        this.collateDetails(errorCode, messageArgs);
    }

    protected void reset() {
        this.errorCode = null;
        this.errorId = null;
        this.categoryId = null;
        this.severity = null;
        this.helpId = null;
        this.resourceBundle = null;
        this.message = null;
        this.hint = null;
        this.hintId = null;
        this.errorFQN = null;
        this.type = null;
        this.cause = null;
        this.action = null;
        this.description = null;
    }

    protected void collateDetails(ErrorCode errorCode, Object ... messageArgs) {
        this.reset();
        this.errorCode = errorCode;
        try {
            Field field = errorCode.getClass().getField(errorCode.name());
            ErrorCodeDef errorCodeDef = field.getAnnotation(ErrorCodeDef.class);
            if (errorCodeDef != null) {
                this.errorId = errorCodeDef.id();
                this.severity = errorCodeDef.severity();
                this.helpId = errorCodeDef.helpId().trim();
                this.helpId = this.helpId.length() == 0 ? null : this.helpId;
                this.hintId = errorCodeDef.hintId().trim();
            }
        }
        catch (Exception e) {
            logger.info("Failed to find ErrorCodeDef " + errorCode.name() + ". Cause: " + e.getMessage());
        }
        ErrorCodeCategory errorCodeCategory = errorCode.getClass().getAnnotation(ErrorCodeCategory.class);
        if (errorCodeCategory != null) {
            String categoryHintId;
            this.type = errorCodeCategory.type();
            this.resourceBundle = errorCodeCategory.resourceBundle();
            this.categoryId = errorCodeCategory.id();
            String categoryHelpId = errorCodeCategory.helpId();
            if (categoryHelpId.trim().length() != 0 && (this.helpId == null || this.helpId.trim().length() == 0)) {
                this.helpId = categoryHelpId;
            }
            if ((categoryHintId = errorCodeCategory.hintId()).trim().length() != 0 && (this.hintId == null || this.hintId.trim().length() != 0)) {
                this.hintId = categoryHintId;
            }
        }
        if (this.hintId == null || this.hintId.trim().length() == 0) {
            this.hintId = ResourceKey.hint(errorCode.getClass());
        }
        if (this.resourceBundle != null) {
            if (this.errorId != null && this.categoryId != null) {
                this.errorFQN = MessageFormat.format(FMT_ERROR_FQN, this.type, this.categoryId, this.errorId);
            }
            Application application = Application.getInstance();
            Resource resource = application.getResource(this.resourceBundle);
            this.description = errorCode instanceof Enum ? resource.getString((Enum)((Object)errorCode), messageArgs) : resource.getStatusString(errorCode, messageArgs);
            this.message = this.description != null && this.errorFQN != null ? MessageFormat.format(FMT_ERROR_MESSAGE, this.errorFQN, this.description) : this.description;
            this.action = resource.getString(ResourceKey.action(errorCode), "", messageArgs);
            this.cause = resource.getString(ResourceKey.cause(errorCode), "", messageArgs);
            if (this.hintId != null) {
                try {
                    this.hint = resource.getProperty(this.hintId, new Object[0]);
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
        }
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public void setErrorId(String errorId) {
        this.errorId = errorId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getHintId() {
        return this.hintId;
    }

    public void setHintId(String hintId) {
        this.hintId = hintId;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getErrorFQN() {
        return this.errorFQN;
    }

    public void setErrorFQN(String errorFQN) {
        this.errorFQN = errorFQN;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setMessageArgs(Object[] messageArgs) {
        this.messageArgs = messageArgs;
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    public Content getExtraDetails() {
        return this.extraDetails;
    }

    public void setExtraDetails(Content extraDetails) {
        this.extraDetails = extraDetails;
    }

    public String getDetailedMessage() {
        return String.format("%s\nCause: %s\nAction: %s\n", this.getMessage(), this.getCause(), this.getAction());
    }
}

